import { Editor, EditorState, RichUtils } from 'draft-js';
import * as React from 'react';
import { ToolbarIcon } from './toolbar-icon';

interface BlockType {
  label?: string;
  icon?: string;
  style: string;
}

const BLOCK_TYPES: BlockType[] = [
  { label: 'H1', style: 'header-one' },
  { label: 'H2', style: 'header-two' },
  { icon: 'fa fa-list-ul', style: 'unordered-list-item' },
  { icon: 'fa fa-list-ol', style: 'ordered-list-item' },
  { icon: 'fa fa-quote-left', style: 'blockquote' }
];

interface SideToolbarExtrasProps {
  editorState: EditorState;
  onToggle: any;
}

export class SideToolbarExtras extends React.Component<SideToolbarExtrasProps, void> {
  public render() {
    const { editorState, onToggle } = this.props;
    const selection = editorState.getSelection();
    const blockType = editorState.getCurrentContent()
                                .getBlockForKey(selection.getStartKey())
                                .getType();
    const blockTypes = BLOCK_TYPES.map(type =>
      <ToolbarIcon
        key={type.label || type.icon}
        active={type.style === blockType}
        label={type.label}
        icon={type.icon}
        onToggle={onToggle}
        style={type.style}
      />
    );
    return (
      <div className="toolbar side">
        <ul className="toolbar-icons">
          {blockTypes}
        </ul>
      </div>
    );
  }
}

export interface SideToolbarProps {
  editorState: EditorState;
  onUploadImage: any;
  onToggle: any;
}

export class SideToolbar extends React.Component<any, any> {
  constructor(props: any) {
    super(props);
    this.state = {
      isExpanded: false
    };
  }

  public render() {
    const { isExpanded } = this.state;
    const { editorState, onUploadImage, onToggle } = this.props;
    const preventDefault = (e: any) => e.preventDefault();
    const setExpanded = () => this.setState({ isExpanded: true });
    const unsetExpanded = () => this.setState({ isExpanded: false });
    let isExpandedElement: JSX.Element;
    if (isExpanded) {
      isExpandedElement = <SideToolbarExtras editorState={editorState} onToggle={onToggle} />;
    }

    return (
      <div style={this.props.style} className="side-toolbar">
        <i
          className="fa fa-photo"
          onMouseDown={preventDefault}
          onClick={onUploadImage}
        />
        <i
          className="fa fa-bars"
          onMouseEnter={setExpanded}
          onMouseDown={preventDefault}
          onMouseLeave={unsetExpanded}
        >
          {isExpandedElement}
        </i>
      </div>
    );
  }
}
