import * as React from 'react';

export interface ToolbarIconProps {
  active: boolean;
  label?: string;
  icon?: string;
  onToggle: any;
  style: string;
}

export class ToolbarIcon extends React.Component<ToolbarIconProps, void> {
  public render() {
    const { label, icon, active, onToggle, style } = this.props;
    let classes = ['toolbar-icon'];
    if (active) {
      classes.push('toolbar-icon--active');
    }

    const mouseDown = (e: any) => {
      e.preventDefault();
      onToggle(style);
    };

    return (
      <li className={classes.join(' ')} onMouseDown={mouseDown}>
        {label ? label : <i className={icon}/>}
      </li>
    );
  }
}
