import { EditorState, convertToRaw } from 'draft-js';
import {
  Editor,
  createEditorState,
} from 'medium-draft';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  EventSchema,
  EventModel,
  createOrUpdateEvent,
  getEvent,
  getEvents,
  deleteEvent
} from 'tourney-sdk-react';

import { EventList } from './list';
import { Event } from './model';
import { Form } from '../form';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class EventComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const eventIds = Object.keys(state.tourney.events);
    const events = denormalize(eventIds, [EventSchema], state.tourney);
    return {
      events
    };
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        event: {
        },
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    this.props.dispatch(getEvents())
    .then((response: any) => this.setState({ loading: false }));
  }

  public editEvent(event: EventModel) {
    this.setState({ form: {
      event,
      visible: true
    }});
  }

  public destroyEvent(event: EventModel) {
    this.props.dispatch(deleteEvent(event.id));
  }

  public showEventForm() {
    this.setState({ form: { visible: true } });
  }

  public hideEventForm() {
    this.setState({ form: { visible: false } });
  }

  public handleFormChange(e: Event, event: EventModel) {
    this.setState({ form: { event, visible: true } });
  }

  public render() {
    const listActions = {
      edit: this.editEvent.bind(this),
      delete: this.destroyEvent.bind(this)
    };

    return <Container fluid>
      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={Event}
            object={this.state.form.event}
            action={createOrUpdateEvent}
            schema={EventSchema}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideEventForm.bind(this)}
            onCancel={this.hideEventForm.bind(this)}
          />
        </Segment>
      </Modal>

      <Menu attached="top">
        <Menu.Item><Button onClick={this.showEventForm.bind(this)}>Create</Button></Menu.Item>
      </Menu>

      <Segment padded attached="bottom" loading={this.state.loading}>
        <EventList
          events={this.props.events}
          actions={listActions}
        />
      </Segment>
    </Container>;
  }
}

export const Events = connect(EventComponent.mapStateToProps)(EventComponent);
export * from './list';
