import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { EventModel } from 'tourney-sdk-react';
import { Image, Button, Table, Grid } from 'semantic-ui-react';

export class EventList extends React.Component<any, any> {
  public action(action: Function, event: EventModel) {
    return () => action(event);
  }

  public render() {
    const events: EventModel[] = this.props.events;
    const eventRows = _.map(events, (event, id) => {
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, event).bind(this)}>{name}</Button>
      );

      return <Table.Row key={id}>
        <Table.Cell>{event.id}</Table.Cell>
        <Table.Cell>{event.title}</Table.Cell>
        <Table.Cell>{event.starts_at}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>ID</Table.HeaderCell>
          <Table.HeaderCell>Title</Table.HeaderCell>
          <Table.HeaderCell>Starts At</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {eventRows}
      </Table.Body>
    </Table>;
  }
}
