import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  GameSchema,
  GameModel,
  createOrUpdateGame,
  getGames
} from 'tourney-sdk-react';

import { GameList } from './list';
import { Game } from './model';
import { Form } from '../form';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class GamesComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const gameIds = Object.keys(state.tourney.games);
    const games = denormalize(gameIds, [GameSchema], state.tourney);
    return {
      games
    }
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        game: {
          name: ''
        },
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    this.props.dispatch(getGames())
    .then((response: any) => this.setState({ loading: false }));
  }

  public editGame(game: GameModel) {
    this.setState({ form: {
      game,
      visible: true
    }});
  }

  public showGameForm() {
    this.setState({ form: { visible: true } });
  }

  public hideGameForm() {
    this.setState({ form: { visible: false } });
  }

  public handleFormChange(e: Event, game: GameModel) {
    this.setState({ form: { game, visible: true } });
  }

  public render() {
    const listActions = {
      edit: this.editGame.bind(this)
    };

    return <Container fluid>
      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={Game}
            object={this.state.form.game}
            action={createOrUpdateGame}
            schema={GameSchema}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideGameForm.bind(this)}
            onCancel={this.hideGameForm.bind(this)}
          />
        </Segment>
      </Modal>

      <Menu attached="top">
        <Menu.Item><Button onClick={this.showGameForm.bind(this)}>Create</Button></Menu.Item>
      </Menu>

      <Segment padded attached="bottom" loading={this.state.loading}>
        <GameList
          games={this.props.games}
          actions={listActions}
        />
      </Segment>
    </Container>;
  }
}

export const Games = connect(GamesComponent.mapStateToProps)(GamesComponent);
export * from './list';
