import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { GameModel } from 'tourney-sdk-react';
import { Image, Button, Table, Grid } from 'semantic-ui-react';

export class GameList extends React.Component<any, any> {
  public action(action: Function, game: GameModel) {
    return () => action(game);
  }

  public render() {
    const games: Array<GameModel> = this.props.games;
    const gameRows = _.map(games, (game, id) => {
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, game).bind(this)}>{name}</Button>
      );

      return <Table.Row key={id}>
        <Table.Cell><Image src={game.cover.preview} height="80px"/></Table.Cell>
        <Table.Cell>{game.id}</Table.Cell>
        <Table.Cell>{game.name}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Cover</Table.HeaderCell>
          <Table.HeaderCell>ID</Table.HeaderCell>
          <Table.HeaderCell>Name</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {gameRows}
      </Table.Body>
    </Table>;
  }
}
