import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { LoginButton } from '../loginButton';

import { Dimmer, Loader } from 'semantic-ui-react';

const style = require('./style.scss');

export class Login extends React.Component<any, any> {
  public render() {
    const { loading } = this.props;
    return <Dimmer className="login" active>
      <Loader className="login" disabled={!loading} size="huge" inverted indeterminate />
      <div style={{ display: loading ? 'none' : 'block' }}>
        <LoginButton />
      </div>
    </Dimmer>;
  }
}
