import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';

import { authUser, UserModel } from 'tourney-sdk-react';

import { Icon, Button, Image } from 'semantic-ui-react';

const style = require('./style.scss');

const mapDispatchToProps = (dispatch: any) => {
  return { dispatch };
};

const mapStateToProps = (state: any) => {
  return state;
};

export class LoginButtonComponent extends React.Component<any, any> {
  private logOut() {
    localStorage.removeItem('token');
    window.location.href = '/';
  }

  public render() {
    const { user } = this.props;

    if (user) {
      return <div>
        <Image src={user.avatar} avatar /> <span>{user.display_name}</span>
        <Link to="/" className="small" onClick={this.logOut}> <Icon name="external" /></Link>
      </div>
    }

    return <Button onClick={this.handleClick.bind(this)}>
      {'Login' + (user ? user.name : '')}
    </Button>;
  }

  private handleClick(e: MouseEvent) {
    e.preventDefault();

    let currentUser = _.get(this.props, 'tourney.userAuth.current') as UserModel;
    if (!currentUser) {
      this.props.dispatch(authUser());
    }
  }
}
export const LoginButton = connect(mapStateToProps, mapDispatchToProps)(LoginButtonComponent);
