import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  MatchSchema,
  MatchModel,
  createOrUpdateMatch,
  getGames,
  getMatches,
  getTeams
} from 'tourney-sdk-react';

import { MatchList } from './list';
import { Match } from './model';
import { Form } from '../form';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class MatchesComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const matchIds = Object.keys(state.tourney.matches);
    const matches = denormalize(matchIds, [MatchSchema], state.tourney);
    return {
      matches
    }
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        match: {
          name: ''
        },
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    Promise.all([
      this.props.dispatch(getMatches()),
      this.props.dispatch(getGames()),
      this.props.dispatch(getTeams())
    ])
    .then((response: any) => this.setState({ loading: false }));
  }

  public editMatch(match: MatchModel) {
    this.setState({ form: {
      match,
      visible: true
    }});
  }

  public showMatchForm() {
    this.setState({ form: { visible: true } });
  }

  public hideMatchForm() {
    this.setState({ form: { visible: false } });
  }

  public handleFormChange(match: any) {
    this.setState({ form: { match, visible: true } });
  }

  public render() {
    const listActions = {
      edit: this.editMatch.bind(this)
    };

    const listContent = this.state.loading
      ? undefined
      : <MatchList
          matches={this.props.matches}
          actions={listActions}
        />;

    return <Container fluid>
      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={Match}
            schema={MatchSchema}
            action={createOrUpdateMatch}
            object={this.state.form.match}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideMatchForm.bind(this)}
            onCancel={this.hideMatchForm.bind(this)}
          />
        </Segment>
      </Modal>

      <Menu attached="top">
        <Menu.Item><Button onClick={this.showMatchForm.bind(this)}>Create</Button></Menu.Item>
      </Menu>

      <Segment padded attached="bottom" loading={this.state.loading}>
        {listContent}
      </Segment>
    </Container>;
  }
}

export const Matches = connect(MatchesComponent.mapStateToProps)(MatchesComponent);
export * from './list';
