import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { MatchModel, TeamModel, OpponentModel } from 'tourney-sdk-react';
import { Button, Table, Grid } from 'semantic-ui-react';

export class MatchList extends React.Component<any, any> {
  public action(action: Function, match: MatchModel) {
    return () => action(match);
  }

  public render() {
    let matches: Array<any> = this.props.matches;

    let matchRows = _.map(matches, (match, id) => {
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, match).bind(this)}>{name}</Button>
      );

      return <Table.Row key={id}>
        <Table.Cell>{match.opponents ? match.opponents.map((opponent: OpponentModel) => opponent.contender.name).join(' vs ') : ''}</Table.Cell>
        <Table.Cell>{match.game ? match.game.name : ''}</Table.Cell>
        <Table.Cell>{match.winner ? match.winner.name : ''}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Teams</Table.HeaderCell>
          <Table.HeaderCell>Game</Table.HeaderCell>
          <Table.HeaderCell>Winner</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {matchRows}
      </Table.Body>
    </Table>;
  }
}
