import * as _ from 'lodash';
import * as moment from 'moment';
import {
  GameModel,
  GameSchema,
  SeriesModel,
  SeriesSchema,
  TeamModel,
  TeamSchema,
  OpponentModel,
  OpponentSchema,
  MatchModel,
  MatchSchema
} from 'tourney-sdk-react';
import { Team } from '../team/model';

export class Opponent {
  public static properties = [
    { name: 'contender_id',
      type: 'select',
      schema: TeamSchema,
      collection: 'tourney.teams' },
    { name: 'contender_type',
      type: 'hidden',
      default: 'Team' },
    { name: 'is_winner',
      type: 'checkbox' }
  ];
  public id: number;
  public match_id: string;
}

export class Match implements MatchModel {
  public static properties = [
    { name: 'id',
      type: 'text',
      disabled: true },
    { name: 'game_id',
      type: 'select',
      schema: GameSchema,
      collection: 'tourney.games' },
    { name: 'scheduled_at',
      type: 'datetime-local',
      default: () => moment().startOf('hour') },
    { name: 'winner_id',
      type: 'select',
      schema: OpponentSchema,
      // winner_id currently only works on /matches page,
      // on /series, it uses series.opponents, which isn't good.
      collection: 'object.opponents',
      // this is not ideal, it will default and give us ids,
      // maybe we should have it pass through a callback function
      // that looks like (model) => {key: XYZ, text: XYZ}[]

      // like this 
      // options: (collection: OpponentModel[]) => {
      //   return collection.map(
      //     (opp: OpponentModel) => {key: opp.id, text: opp.contender.id });
      // }
    },
    { name: 'opponents',
      type: 'association',
      model: Opponent,
      schema: OpponentSchema }
  ];
  public id: string;
  public game: GameModel;
  public winner: OpponentModel;
  public series: SeriesModel;
  public opponents: OpponentModel[];
  public state: '' | 'locked' | 'decided';
  public scheduled_at: string;
  public created_at: string;
  public updated_at: string;
}
