import { config } from 'config';
import {
  ImageSideButton,
  Block,
  addNewBlock,
  createEditorState,
  Editor,
} from 'medium-draft';
import * as React from 'react';
import { connect } from 'react-redux';
import { uploadImage } from 'tourney-sdk-react';

class CustomImageSideButtonComponent extends ImageSideButton {
  public onChange(e: any) {
    const file = e.target.files[0];
    this.props.dispatch(uploadImage(file))
      .then((result: any) => {
        // result
        this.props.setEditorState(addNewBlock(
          this.props.getEditorState(),
          Block.IMAGE, {
            src: `${result.url}`,
          }
        ));
      });
    this.props.close();
  }
}

export const CustomImageSideButton = connect()(CustomImageSideButtonComponent);
