import { EditorState, convertToRaw } from 'draft-js';
import * as Immutable from 'immutable';
import * as _ from 'lodash';
import {
  Editor,
  createEditorState,
} from 'medium-draft';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { CustomImageSideButton } from './image-button';

require('./styles.scss');

const blockButtons = [{
  label: 'H1',
  style: 'header-one',
  icon: 'header',
  description: 'Heading 1',
}, {
  label: 'H2',
  style: 'header-two',
  icon: 'header-two',
  description: 'Heading 2',
}, {
  label: 'Q',
  style: 'blockquote',
  icon: 'quote-right',
  description: 'Blockquote',
}, {
  label: 'UL',
  style: 'unordered-list-item',
  icon: 'list-ul',
  description: 'Unordered List',
}];

const inlineButtons = [{
  label: 'B',
  style: 'BOLD',
  icon: 'bold',
  description: 'Bold',
}, {
  label: 'I',
  style: 'ITALIC',
  icon: 'italic',
  description: 'Italic',
}, {
  label: 'U',
  style: 'UNDERLINE',
  icon: 'underline',
  description: 'Underline',
}, {
  label: 'S',
  style: 'STRIKETHROUGH',
  icon: 'strikethrough',
  description: 'Strikethrough',
}, {
  label: '#',
  style: 'hyperlink',
  icon: 'link',
  description: 'Add a link',
}];

const sideButtons = [{
  title: 'Image',
  component: CustomImageSideButton,
}];

interface MediumEditorProps {
  onUpdate: (editorState: EditorState) => {};
  intialState: EditorState;
  placeholder?: string;
}

export class MediumEditor extends React.Component<any, any> {
  public constructor(props: any) {
    super(props);

    const initData = _.isEmpty(props.initialState)
      ? createEditorState()
      : createEditorState(JSON.parse(props.initialState));
    this.state = {
      editorState: initData
    };
  }

  public render() {
    const placeholderText = this.props.placeholder || 'Editor Text...';
    return (
      <Editor
        ref="editor"
        placeholder={placeholderText}
        editorState={this.state.editorState}
        onChange={this.updateDraft.bind(this)}
        inlineButtons={inlineButtons}
        blockButtons={blockButtons}
        sideButtons={sideButtons}
      />);
  }

  private updateDraft(editorState: EditorState) {
    this.setState({
      editorState
    });
    this.props.onUpdate(editorState);
  }
}
