import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  UserSchema,
  UserModel,
  TeamModel,
  TeamSchema,
  getTeams,
  getUsers,
  updateUser
} from 'tourney-sdk-react';

import { Form } from '../form';
import { PlayersList } from './list';
import { Player } from './model';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class PlayerComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const teamIds = _.keys(state.tourney.teams);
    const teams = denormalize(teamIds, [TeamSchema], state.tourney);
    return {
      teams
    };
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        user: {
          email: ''
        },
        visible: false
      },
      entryForm: {
        object: {},
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    this.props.dispatch(getTeams({
      limit: 500
    }))
    .then((response: any) => this.setState({ loading: false }));
  }

  public showUserForm() {
    this.setState({ form: { visible: true } });
  }

  public hideModal(e: Event) {
    if (e && e.preventDefault) {
      e.preventDefault();
    }

    this.setState({ form: { visible: false } });
  }

  public handleFormChange(user: UserModel) {
    this.setState({ form: {
      user,
      visible: true
    }});
  }

  public editUser(user: UserModel) {
    this.setState({ form: {
      user,
      visible: true
    }});
  }

  public render() {
    let listActions = {
      edit: this.editUser.bind(this)
    };

    return <Container fluid>
      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={Player}
            object={this.state.form.user}
            schema={UserSchema}
            action={updateUser}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideModal.bind(this)}
            onCancel={this.hideModal.bind(this)}
          />
        </Segment>
      </Modal>

      <Segment padded attached="bottom" loading={this.state.loading}>
        <PlayersList
          teams={this.props.teams}
          actions={listActions}
        />
      </Segment>
    </Container>;
  }
}

export const Players = connect(PlayerComponent.mapStateToProps)(PlayerComponent);
export * from './list';
export * from './model';
