import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { Table, Button, Segment, Header } from 'semantic-ui-react';

import { TeamModel, UserModel } from 'tourney-sdk-react';

export class PlayersList extends React.Component<any, any> {
  public action(action: Function, user: UserModel) {
    return () => action(user);
  }

  public render() {
    const teams: TeamModel[] = this.props.teams;

    const teamElements = teams.map((team: TeamModel) => {
      const listElement = this.renderPlayerList(team.users);
      return (
        <div className="team-group" style={{ marginTop: '1rem' }}>
          <Segment padded>
            <Header>{team.name}</Header>
            {listElement}
          </Segment>
        </div>
      );
    });

    return (
      <section>
        {teamElements}
      </section>
    );
  }

  private renderPlayerList(users: UserModel[]) {
    const userRows = _.map(users, (user, id) => {
      const rowActions = _.map(this.props.actions, (action: Function, name: string) =>
                             <Button key={name} onClick={this.action(action, user).bind(this)}>{name}</Button>);

      const photoElement = _.get(user, ['photo', 'original'])
        ? <i className="fa fa-check"/>
        : undefined;
      return <Table.Row key={id}>
        <Table.Cell>{user.handle}</Table.Cell>
        <Table.Cell>{user.first_name}</Table.Cell>
        <Table.Cell>{user.last_name}</Table.Cell>
        <Table.Cell>{photoElement}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Handle</Table.HeaderCell>
          <Table.HeaderCell>First Name</Table.HeaderCell>
          <Table.HeaderCell>Last Name</Table.HeaderCell>
          <Table.HeaderCell>Photo</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {userRows}
      </Table.Body>
    </Table>;
  }
}
