import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { SeriesModel, TeamModel } from 'tourney-sdk-react';
import { Button, Table, Grid } from 'semantic-ui-react';
import Moment from 'react-moment';

export class SeriesList extends React.Component<any, any> {
  public action(action: Function, series: SeriesModel) {
    return () => action(series);
  }

  public render() {
    const series: Array<any> = this.props.series;
    const seriesRows = _.map(series, (series, id) => {
      const startsAt = series.matches.length > 0
        ? <Moment>{series.matches[0].scheduled_at}</Moment> : '';
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, series).bind(this)}>{name}</Button>
      );
      const opponents = series.matches.map((match: any) => {
        return match.opponents.map((opponent: any) => opponent.contender ? opponent.contender.name : '?').join(' vs ');
      }).join(', ');

      return <Table.Row key={id}>
        <Table.Cell>{series.type}</Table.Cell>
        <Table.Cell>{opponents}</Table.Cell>
        <Table.Cell>{startsAt}</Table.Cell>
        <Table.Cell>{series.matches.length}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Type</Table.HeaderCell>
          <Table.HeaderCell>Opponents</Table.HeaderCell>
          <Table.HeaderCell>Scheduled At</Table.HeaderCell>
          <Table.HeaderCell>Matches</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {seriesRows}
      </Table.Body>
    </Table>;
  }
}
