import * as moment from 'moment';
import {
  OpponentModel,
  OpponentSchema,
  MatchModel,
  MatchSchema,
  SeriesModel,
  GameSchema
} from 'tourney-sdk-react';
import { Match, Opponent } from '../match/model';
import { Team } from '../team/model';

export class Series implements SeriesModel {
  public static properties = [
    { name: 'id',
      type: 'text',
      disabled: true },
    { name: 'type',
      type: 'select',
      options: [{
        text: 'Best of 5',
        value: 'Series::Bo5'
      }, {
        text: 'Proleague',
        value: 'Series::Proleague'
      }]},
    { name: 'game_id',
      type: 'select',
      schema: GameSchema,
      collection: 'tourney.games' },
    { name: 'matches',
      type: 'association',
      model: Match,
      schema: MatchSchema },
    { name: 'opponents',
      type: 'association',
      model: Opponent,
      schema: OpponentSchema },
    { name: 'skip_curse',
      type: 'checkbox' }
  ];
  public id: string;
  public matches: MatchModel[];
  public scheduled_at: string;
  public created_at: string;
  public updated_at: string;
}
