import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  TeamSchema,
  TournamentEntrySchema,
  createOrUpdateTeam,
  getTeams,
  getTournaments,
  createTournamentEntry
} from 'tourney-sdk-react';

import { Form } from '../form';
import { TeamList } from './list';
import { Team } from './model';
import { TournamentEntry } from '../tournamentEntry/model';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class TeamsComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const teamIds = Object.keys(state.tourney.teams);
    const teams = denormalize(teamIds, [TeamSchema], state.tourney);
    return {
      teams
    }
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        team: {
          name: ''
        },
        visible: false
      },
      entryForm: {
        object: {},
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    this.props.dispatch(getTournaments());
    this.props.dispatch(getTeams({ limit: 500 }))
    .then((response: any) => this.setState({ loading: false }));
  }

  public showTeamForm() {
    this.setState({ form: { visible: true } });
  }

  public hideModal(e: Event) {
    if (e && e.preventDefault) {
      e.preventDefault();
    }

    this.setState({ form: { visible: false },
                  entryForm: { visible: false } });
  }

  public handleFormChange(team: any) {
    this.setState({ form: { team, visible: true } });
  }

  public editTeam(team: any) {
    this.setState({ form: {
      team,
      visible: true
    }});
  }

  public signupTeam(team: any) {
    this.setState({ entryForm: {
      object: {
        team_id: team.id,
        tournament_id: ''
      },
      visible: true
    }});
  }

  public render() {
    let listActions = {
      edit: this.editTeam.bind(this),
      signup: this.signupTeam.bind(this)
    };

    return <Container fluid>
      <Modal basic open={this.state.entryForm.visible}>
        <Segment padded>
          <Form
            for={TournamentEntry}
            schema={TournamentEntrySchema}
            object={this.state.entryForm.object}
            action={createTournamentEntry}
            onSuccess={this.hideModal.bind(this)}
            onCancel={this.hideModal.bind(this)}
          />
        </Segment>
      </Modal>

      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={Team}
            schema={TeamSchema}
            action={createOrUpdateTeam}
            object={this.state.form.team}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideModal.bind(this)}
            onCancel={this.hideModal.bind(this)}
          />
        </Segment>
      </Modal>

      <Menu attached="top">
        <Menu.Item><Button onClick={this.showTeamForm.bind(this)}>Create</Button></Menu.Item>
      </Menu>

      <Segment padded attached="bottom" loading={this.state.loading}>
        <TeamList
          teams={this.props.teams}
          actions={listActions}
        />
      </Segment>
    </Container>;
  }
}

export const Teams = connect(TeamsComponent.mapStateToProps)(TeamsComponent);
export * from './list';
