import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { Link } from 'react-router-dom';
import { Table, Button } from 'semantic-ui-react';

import { UserModel } from 'tourney-sdk-react';

export class TeamList extends React.Component<any, any> {
  public action(action: Function, team: Object) {
    return () => action(team);
  }

  public render() {
    let teams: Array<any> = this.props.teams;

    let teamRows = _.map(teams, (team, id) => {
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, team).bind(this)}>{name}</Button>
      );

      const tournamentEntries = _.map(
        team.tournament_entries,
        (te: any, idx: number) => {
          return <Link to={'/tournament_entries?team_id=' + team.id} key={idx}>
            {te && te.tournament ? te.tournament.name : te.tournament_id}
          </Link>;
        }
      );

      const hasCover = _.get(team, ['cover', 'original'])
        ? <i className="fa fa-check"/>
        : undefined;

      const hasLogo = _.get(team, ['logo', 'original'])
        ? <i className="fa fa-check"/>
        : undefined;

      return <Table.Row key={id}>
        <Table.Cell>{team.id}</Table.Cell>
        <Table.Cell>{team.name}</Table.Cell>
        <Table.Cell>{hasCover}</Table.Cell>
        <Table.Cell>{hasLogo}</Table.Cell>
        <Table.Cell>{tournamentEntries}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>#</Table.HeaderCell>
          <Table.HeaderCell>Name</Table.HeaderCell>
          <Table.HeaderCell>Cover</Table.HeaderCell>
          <Table.HeaderCell>Logo</Table.HeaderCell>
          <Table.HeaderCell>Tournaments</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {teamRows}
      </Table.Body>
    </Table>;
  }
}
