import { UserModel, TeamModel } from 'tourney-sdk-react';

export class Team implements TeamModel {
  public static properties = [
    { name: 'name',
      type: 'text' },
    { name: 'slug',
      type: 'text' },
    { name: 'description',
      type: 'draft',
      placeholder: 'Team Description' },
    { name: 'website',
      type: 'text' },
    { name: 'name',
      type: 'text' },
    { name: 'cover',
      type: 'image-upload' },
    { name: 'cover',
      type: 'image-upload' },
    { name: 'logo',
      type: 'image-upload' },
    { name: 'social',
      type: 'socials' },
  ];
  public id: string;
  public name: string;
  public organization_id: string | null;
  public game_id: string | null;
  public created_at: string;
  public updated_at: string;
  public users: UserModel[];
}
