import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  TournamentSchema,
  TournamentModel,
  createOrUpdateTournament,
  getGames,
  getTournaments
} from 'tourney-sdk-react';

import { TournamentList } from './list';
import { Tournament } from './model';
import { Form } from '../form';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class TournamentsComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const tournamentIds = Object.keys(state.tourney.tournaments);
    const tournaments = denormalize(tournamentIds, [TournamentSchema], state.tourney);
    return {
      tournaments
    }
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        tournament: {
          name: ''
        },
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    Promise.all([
      this.props.dispatch(getTournaments()),
      this.props.dispatch(getGames())
    ])
    .then((response: any) => this.setState({ loading: false }));
  }

  public editTournament(tournament: TournamentModel) {
    this.setState({ form: {
      tournament,
      visible: true
    }});
  }

  public showTournamentForm() {
    this.setState({ form: { visible: true } });
  }

  public hideTournamentForm() {
    this.setState({ form: { visible: false } });
  }

  public handleFormChange(tournament: any) {
    this.setState({ form: { tournament, visible: true } });
  }

  public render() {
    const listActions = {
      edit: this.editTournament.bind(this)
    };

    return <Container fluid>
      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={Tournament}
            schema={TournamentSchema}
            action={createOrUpdateTournament}
            object={this.state.form.tournament}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideTournamentForm.bind(this)}
            onCancel={this.hideTournamentForm.bind(this)}
          />
        </Segment>
      </Modal>

      <Menu attached="top">
        <Menu.Item><Button onClick={this.showTournamentForm.bind(this)}>Create</Button></Menu.Item>
      </Menu>

      <Segment padded attached="bottom" loading={this.state.loading}>
        <TournamentList
          tournaments={this.props.tournaments}
          actions={listActions}
        />
      </Segment>
    </Container>;
  }
}

export const Tournaments = connect(TournamentsComponent.mapStateToProps)(TournamentsComponent);
export * from './list';
