import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { TournamentModel } from 'tourney-sdk-react';
import { Button, Table, Grid } from 'semantic-ui-react';

export class TournamentList extends React.Component<any, any> {
  public action(action: Function, tournament: TournamentModel) {
    return () => action(tournament);
  }

  public render() {
    let tournaments: Array<any> = this.props.tournaments;

    let tournamentRows = _.map(tournaments, (tournament, id) => {
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, tournament).bind(this)}>{name}</Button>
      );

      return <Table.Row key={id}>
        <Table.Cell>{tournament.name}</Table.Cell>
        <Table.Cell>{tournament.game ? tournament.game.name : ''}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Name</Table.HeaderCell>
          <Table.HeaderCell>Game</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {tournamentRows}
      </Table.Body>
    </Table>;
  }
}
