import {
  GameModel,
  TournamentModel,
  TournamentStageModel,
  TournamentStageSchema
} from 'tourney-sdk-react';

export class TournamentStage implements TournamentStageModel {
  public static properties = [
    { name: 'name',
      type: 'text' },
    { name: 'starts_at',
      type: 'datetime-local' },
    { name: 'color',
      type: 'color' },
    { name: 'ends_at',
      type: 'datetime-local' }
  ];
  public id: string;
  public tournament_id: string;
  public name: string;
  public progress: Number;
  public starts_at: string;
  public ends_at: string;
}

export class Tournament implements TournamentModel {
  public static properties = [
    { name: 'name',
      type: 'text' },
    { name: 'entrants_type',
      type: 'select',
      options: [{
        text: 'Team',
        value: 'Team'
      }]},
    { name: 'game_id',
      type: 'select',
      collection: 'tourney.games' },
    {
      name: 'logo',
      type: 'image-upload'
    },
    { name: 'stages',
      type: 'association',
      model: TournamentStage,
      schema: TournamentStageSchema }
  ];
  public id: string;
  public name: string;
  public description: string | null;
  public season_id: string | null;
  public game: GameModel;
  public entrants_type: string;
  public created_at: string;
  public updated_at: string;
}
