import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { TournamentEntryModel } from 'tourney-sdk-react';

import { Button, Table, Grid } from 'semantic-ui-react';

export class TournamentEntryList extends React.Component<any, any> {
  public action(action: Function, tournamentEntry: TournamentEntryModel) {
    return () => action(tournamentEntry);
  }

  public render() {
    const tournamentEntries = this.props.tournamentEntries as TournamentEntryModel[];
    const tournamentEntryRows = _.map(tournamentEntries, (tournamentEntry, id) => {
      if (!tournamentEntry) {
        return <Table.Row />;
      }

      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, tournamentEntry).bind(this)}>{name}</Button>
      );

      const entrantName = tournamentEntry.entrant ? tournamentEntry.entrant.name : tournamentEntry.entrant_id;
      const tournamentName = tournamentEntry.tournament ? tournamentEntry.tournament.name : tournamentEntry.tournament_id;

      return <Table.Row key={id}>
        <Table.Cell>{entrantName} ({tournamentEntry.entrant_type})</Table.Cell>
        <Table.Cell>{tournamentName}</Table.Cell>
        <Table.Cell>{tournamentEntry.flags.join(', ')}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Entrant</Table.HeaderCell>
          <Table.HeaderCell>Tournament</Table.HeaderCell>
          <Table.HeaderCell>Flags</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {tournamentEntryRows}
      </Table.Body>
    </Table>;
  }
}
