import { TournamentEntryModel } from 'tourney-sdk-react';

export class TournamentEntry implements TournamentEntryModel {
  public static properties = [
    { name: 'tournament_id',
      type: 'select',
      collection: 'tourney.tournaments' },
    { name: 'entrant_id',
      aliasFor: ['entrant'],
      type: 'select',
      collection: 'tourney.teams' },
    { name: 'flags',
      type: 'select-multiple',
      options: [{
        text: 'Payment Received',
        value: 'payment_received'
      }, {
        text: 'Best Team Ever',
        value: 'best_team_ever'
      }]}
  ];
  public id: string;
  public tournament_id: string;
  public entrant_id: string;
  public entrant_type: string;
  public flags: Array<string>;
}
