import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import {
  denormalize,
  UserSchema,
  UserModel,
  getUsers,
  updateUser
} from 'tourney-sdk-react';

import { Form } from '../form';
import { UserList } from './list';
import { User } from './model';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class UsersComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const userIds = Object.keys(state.tourney.users).filter((id) => id !== 'current');
    const users = denormalize(userIds, [UserSchema], state.tourney);
    return {
      users
    }
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        user: {
          email: ''
        },
        visible: false
      },
      entryForm: {
        object: {},
        visible: false
      },
      loading: true
    };
  }

  public componentDidMount() {
    this.props.dispatch(getUsers())
    .then((response: any) => this.setState({ loading: false }));
  }

  public showUserForm() {
    this.setState({ form: { visible: true } });
  }

  public hideModal(e: Event) {
    if (e && e.preventDefault) {
      e.preventDefault();
    }

    this.setState({ form: { visible: false } });
  }

  public handleFormChange(user: UserModel) {
    this.setState({ user });
  }

  public editUser(user: UserModel) {
    this.setState({ form: {
      user,
      visible: true
    }});
  }

  public render() {
    let listActions = {
      edit: this.editUser.bind(this)
    };

    return <Container fluid>
      <Modal basic open={this.state.form.visible}>
        <Segment padded>
          <Form
            for={User}
            object={this.state.form.user}
            schema={UserSchema}
            action={updateUser}
            onChange={this.handleFormChange.bind(this)}
            onSuccess={this.hideModal.bind(this)}
            onCancel={this.hideModal.bind(this)}
          />
        </Segment>
      </Modal>

      <Menu attached="top">
        <Menu.Item><Button onClick={this.showUserForm.bind(this)}>Create</Button></Menu.Item>
      </Menu>

      <Segment padded attached="bottom" loading={this.state.loading}>
        <UserList
          users={this.props.users}
          actions={listActions}
        />
      </Segment>
    </Container>;
  }
}

export const Users = connect(UsersComponent.mapStateToProps)(UsersComponent);
export * from './list';
export * from './model';
