import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { Table, Button } from 'semantic-ui-react';

import { UserModel } from 'tourney-sdk-react';

export class UserList extends React.Component<any, any> {
  public action(action: Function, user: UserModel) {
    return () => action(user);
  }

  public render() {
    const users: UserModel[] = this.props.users;
    const userRows = _.map(users, (user, id) => {
      const rowActions = _.map(this.props.actions, (action: Function, name: string) =>
                             <Button key={name} onClick={this.action(action, user).bind(this)}>{name}</Button>);

      return <Table.Row key={id}>
        <Table.Cell>{user.email}</Table.Cell>
        <Table.Cell>{user.email_new}</Table.Cell>
        <Table.Cell>{user.email_token}</Table.Cell>
        <Table.Cell>{user.roles}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>Email</Table.HeaderCell>
          <Table.HeaderCell>New Email</Table.HeaderCell>
          <Table.HeaderCell>Email Token</Table.HeaderCell>
          <Table.HeaderCell>Roles</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {userRows}
      </Table.Body>
    </Table>;
  }
}
