import { UserModel } from 'tourney-sdk-react';

export class User implements UserModel {
  public static properties = [
    { name: 'handle',
      type: 'text' },
    { name: 'first_name',
      type: 'text' },
    { name: 'last_name',
      type: 'text' },
    { name: 'photo',
      type: 'image-upload' },
    { name: 'social',
      type: 'socials' },
    { name: 'email',
      type: 'email' },
    { name: 'email_new',
      type: 'email' },
    { name: 'email_token',
      type: 'string' },
    { name: 'roles',
      type: 'select-multiple',
      options: [{
        text: 'Admin',
        value: 'admin'
      }]}
  ];
  public id: string;
  public handle: string;
  public first_name: string;
  public last_name: string;
  public cover: any;
  public email: string;
  public email_new: string;
  public email_token: string;
  public roles: Array<string>;
}
