import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { Container } from 'semantic-ui-react';
import { updateUser, UserModel, verifyEmailToken } from 'tourney-sdk-react';

import { Form } from '../form';
import { User } from '../user/model';

class UserSettingsComponent extends React.Component<any, any> {
  public static mapStateToProps(state: Object) {
    return state;
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      form: {
        user: this.props.tourney.userAuth.current,
        visible: false
      }
    };
  }

  public componentDidMount() {
    if (this.props.location.pathname === '/settings/verify') {
      this.props.dispatch(verifyEmailToken(this.props.location.query.email_token));
    }
  }

  public componentWillReceiveProps(nextProps: any) {
    let user = _.clone(_.get(nextProps, 'tourney.userAuth.current')) as User;
    if (user) {
      this.setState({ form: { user } });
      this.forceUpdate();
    }
  }

  public render() {
    return <Container fluid>
      <Form
        for={User}
        object={this.state.form.user || {}}
        action={updateUser}
      />
    </Container>;
  }
}

export const UserSettings = connect(UserSettingsComponent.mapStateToProps)(UserSettingsComponent);
