import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { combineReducers, createStore, applyMiddleware, compose } from 'redux';
import * as Tourney from 'tourney-sdk-react';

// Add sdk reducers to our root reducer
const rootReducer = combineReducers({
  tourney: Tourney.reducer
});

// Enable redux dev tools
const composeEnhancers = (window as any).__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;
const store = createStore(rootReducer, composeEnhancers(applyMiddleware(...Tourney.middleware)));

import { config } from 'config';
Tourney.config.apiUrl = config.apiUrl;
Tourney.config.apiClientId = config.apiClientId;
Tourney.config.authToken = localStorage.getItem('token');
Tourney.config.store = store;

import { Provider, connect } from 'react-redux';
import { Router, Route } from 'react-router';
import { createBrowserHistory } from 'history';

export const history = createBrowserHistory();

import {
  App,
  Homepage,
  Teams,
  Users,
  Tournaments,
  TournamentEntries,
  UserSettings,
  Matches,
  Games,
  SeriesIndex,
  Articles,
  ArticleDetail,
  Events,
  Players
} from './components';

// If there's an authToken, fire off an auth request on load.
if (Tourney.config.authToken) {
  store.dispatch(Tourney.authUser(Tourney.config.authToken, '', false));
}

ReactDOM.render(
  <Provider store={store}>
    <Router history={history}>
      <Route>
        <App>
          <Route path="/" component={Homepage} />
          <Route path="/articles" exact={true} component={Articles} />
          <Route path="/articles/:articleId" component={ArticleDetail} />
          <Route path="/settings" component={UserSettings} />
          <Route path="/settings/verify" component={UserSettings} />
          <Route path="/teams" component={Teams} />
          <Route path="/users" component={Users} />
          <Route path="/players" component={Players} />
          <Route path="/tournaments" component={Tournaments} />
          <Route path="/tournament_entries" component={TournamentEntries} />
          <Route path="/games" component={Games} />
          <Route path="/matches" component={Matches} />
          <Route path="/series" component={SeriesIndex} />
          <Route path="/events" component={Events} />
          <Route path="/auth/callback/twitch" component={Homepage} />
        </App>
      </Route>
    </Router>
  </Provider>,
  document.getElementById('main')
);
