import * as qs from 'qs';
import { history } from '../index';

interface QueryParams {
  [key: string]: string | Array<string>;
}

export function cacheKey() {
  const query = get();
  return qs.stringify(query);
}

export function parse(search: string) {
  return qs.parse(search.slice(1));
}

export function update(params: QueryParams) {
  const location = Object.assign({}, history.location);
  const query = get();
  Object.assign(query, params);
  location.search = qs.stringify(query);
  history.push(location);
}

export function get(key: string = undefined, type: any = String) {
  const query = qs.parse(history.location.search.slice(1));
  return key ? query[key] : query;
}
