'use strict';

const path = require('path');
const process = require('process');
const webpack = require('webpack');
const HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports = {
  name: 'client',
  entry: './src/index.tsx',
  target: 'web', // default
  devServer: {
    inline: true,
    hot: true,
    port: 5200
  },
  plugins: [
    new webpack.HotModuleReplacementPlugin(),
    new HtmlWebpackPlugin({
      title: 'Fig',
      template: 'index.ejs'
    }),
    new webpack.EnvironmentPlugin({
      NODE_ENV: 'development',
      API_CLIENT_ID: undefined,
      API_URL: undefined
    })
  ],
  output: {
    path: path.join(process.cwd(), '/dist/'),
    publicPath: '/',
    filename: 'bundle-[hash].js'
  },
  resolve: {
    alias: {
      config: path.join(__dirname, 'config', process.env.NODE_ENV || 'development')
    },
    extensions: ['.ts', '.tsx', '.js', '.jsx'],
    modules: [
      path.join(__dirname, 'app'),
      path.join(__dirname, 'node_modules')
    ]
  },
  module: {
    rules: [
      { test: /\.ts?$/, loader: 'tslint-loader', enforce: 'pre' },
      {
        test: /\.ts(x?)$/,
        loader: 'ts-loader',
        exclude: ['node_modules', 'dist'],
        query: {
          ignoreDiagnostics: [
            2339,
            2305, // https://github.com/Semantic-Org/Semantic-UI-React/pull/1467
            7016, // D A N G E R Z O N E - there are no defs for react-router@4
          ]
        }
      },
      { test: /\.scss$/, loader: "style-loader!css-loader!sass-loader" },
      { test: /\.css$/, loader: "style-loader!css-loader" },
      { test: /\.(woff|woff2|ttf|eot|gif|svg|jpg|png|mp4|webm)$/, loader: "file-loader" }
    ]
  },
  devtool: process.env.NODE_ENV === 'development' ? 'inline-source-map' : 'source-map',
};
