# Edge

The Esports Edge API Service!

Our very own edge API that routes through to all services and bundles/caches output so services don't have to care.

## Development

Install Docker and Docker Compose.

Copy `.env` to `.env.local` and adjust settings for your local environment.

We are currently doing service "discovery" via DNS on staging/production. Pending a better solution for development, you will have to change the `<SERVICE>_HOST` ENV variables to point at the services locally.

`docker-compose up`

## Local Backend Sandbox

`docker-compose-integ.yml` defines overrides for the compose files of the other tourney backend repos it delegates requests to.  
It will look for the other services' docker-compose files in this repo's parent directory, e.g. if this repo is in `~/repo/tourney-edge`, there should also be `~/repo/edb` and `~/repo/tourney-passport`.  
The `bin/dc-integ` script runs `docker-compose` with the proper override order for docker-compose files; it should be possible to simply substitute it for "docker-compose" in the CLI.

Start it all up: `bin/dc-integ up -d`  
Check the status: `bin/dc-integ ps`  
View a service's logs: `bin/dc-integ logs <service>`  
etc.

### Services currently included:

- [edb](http://git-aws.internal.justin.tv/esports/edb)
- [tourney-passport](http://git-aws.internal.justin.tv/esports/tourney-passport)

### Default port mappings:

- API servers:
    - **3001**: `tourney-edge`
    - **3002**: Swagger live docs for `tourney-edge`
    - **3054**: `tourney-passport`
    - **3055**: `edb`
- Databases (postgres):
    - **3154**: `tourney-passport`
    - **3155**: `edb`
