class ApplicationController < ActionController::API
  around_action :handle_exceptions

  def ok
    { status: 200, json: {} }
  end

  def error(status, msg, extra={})
    { status: status, json: {status: status, error: msg}.merge(extra) }
  end

  def missing
    render status: 404
  end

  private

  def render_exception(e)
    Rollbar.error(e) rescue nil
    return if performed?
    status =
      e.is_a?(Edb::Exceptions::HttpError) \
        ? e.status
        : ActionDispatch::ExceptionWrapper.status_code_for_exception(e.class.name)
    context = {env: Rails.env}
    context[:backtrace] = e.backtrace if !Rails.env.production?
    render error(status, e.message, context)
  end

  def handle_exceptions
    yield
  rescue => e
    render_exception(e)
  end
end
