class V1::DocsController < V1::BaseController
  skip_before_action :set_client!

  include Swagger::Blocks

  swagger_root do
    key :swagger, '2.0'
    info do
      key :version, '1.0.0'
      key :title, 'Tourney'
      key :description, 'Not affiliated with Meg.'
      contact do
        key :name, 'Twitch Esports'
        key :email, 'marian@twitch.tv'
      end
    end
    key :host, ''
    key :basePath, '/v1'
    key :consumes, ['application/json']
    key :produces, ['application/json']
  end

  # A list of all classes that have swagger_* declarations.
  SWAGGERED_CLASSES = [
    User,
    UsersController,
    Team,
    TeamInvitation,
    TeamInvitationsController,
    TeamMembersController,
    TeamsController,
    Tournament,
    TournamentsController,
    TournamentEntry,
    TournamentEntriesController,
    Game,
    GamesController,
    Match,
    MatchesController,
    self
  ].freeze

  def index
    render json: Swagger::Blocks.build_root_json(SWAGGERED_CLASSES)
  end
end
