class V1::GamesController < V1::BaseController
  cache_actions :index, :show
  cache_flush_actions :update, :create, :destroy

  api_path '/games',
    description: 'List games',
    method: :get,
    params: {
      ids: { in: :query }
    },
    responses: {
      200 => { schema: [:Game] }
    }

  def index
    render edb.games(params)
  end

  api_path '/games/{id}',
    description: 'Get game',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Game }
    }

  def show
    render edb.game(params)
  end

  api_path '/games/{id}',
    description: 'Update game',
    method: :patch,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Game }
    }

  def update
    render edb.update_game(params)
  end

  api_path '/games',
    description: 'Create game',
    method: :post,
    params: {},
    responses: {
      200 => { schema: :Game }
    }

  def create
    render edb.create_game(params)
  end

  api_path '/games/{id}',
    description: 'Destroy game',
    method: :delete,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Game }
    }

  def destroy
    render edb.delete_game(params)
  end
end
