class V1::ImagesController < V1::BaseController
  skip_before_action :set_client!, only: [:show]

  cache_actions :index, :show
  cache_flush_actions :update, :create, :destroy

  api_path '/images',
    description: 'List images',
    method: :get,
    params: {
      ids: { in: :query }
    },
    responses: {
      200 => { schema: [:Game] }
    }

  def index
    render edb.images(params)
  end

  api_path '/images/{id}',
    description: 'Get image',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Game }
    }

  def show
    render edb.image(params)
  end

  api_path '/images/{id}',
    description: 'Update image',
    method: :patch,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Game }
    }

  def update
    render edb.update_image(params)
  end

  api_path '/images',
    description: 'Create image',
    method: :post,
    params: {},
    responses: {
      200 => { schema: :Game }
    }

  def create
    render edb.create_image(params)
  end

  api_path '/images/{id}',
    description: 'Destroy image',
    method: :delete,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Game }
    }

  def destroy
    render edb.delete_image(params)
  end
end
