class V1::MatchesController < V1::BaseController
  api_path '/matches',
    description: 'List matches',
    method: :get,
    params: {
      ids: { in: :query },
      user_id: { in: :query }
    },
    responses: {
      200 => { schema: [:Match] }
    }

  def index
    render edb.matches(params)
  end

  api_path '/matches/{id}',
    description: 'Get match',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Match }
    }

  def show
    render edb.match(params)
  end

  api_path '/matches/{id}',
    description: 'Update match',
    method: :patch,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Match }
    }

  def update
    render edb.update_match(params)
  end

  api_path '/matches',
    description: 'Create match',
    method: :post,
    params: {},
    responses: {
      200 => { schema: :Match }
    }

  def create
    render edb.create_match(params)
  end

  api_path '/matches/{id}',
    description: 'Destroy match',
    method: :delete,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Match }
    }

  def destroy
    render edb.delete_match(params)
  end
end
