class V1::PassportController < V1::BaseController
  def auth
    if token
      user = V1::UserPresenter.new(token.user, context: self)
      render json: {
        status: 200,
        data: user
      } and return
    end
    handle_auth!
  end

  def callback
    resp = passport.callback(callback_params[:provider], params: callback_params)
    case resp.status
    when 200
      render json: {
        status: resp.status,
        data: V1::UserPresenter.new(JSON.parse(resp.body), context: self)
      }
    else
      render json: {
        error: 'unknown',
        status: resp.status
      }
    end
  end

  private

  def handle_auth!
    resp = passport.auth(auth_params[:provider], params: auth_params)
    case resp.status
    when 302
      redirect = resp.env[:response_headers]['location']
      token = CGI.parse(URI.parse(redirect).query)['state'].join
      # Can't guarantee the browser won't transparently follow a 302 response
      # https://github.com/github/fetch/issues/137
      render json: {
        status: 302,
        token: token,
        redirect: redirect
      }, status: 200
    end
  end

  def auth_params
    params[:provider] ||= 'twitch'

    permitted = [:provider, :token, :client_id]

    # Because omniauth's setup doesn't pass through headers, auth will have to
    # pass along our client ID in params.
    params[:client_id] = client.id if client

    params.permit(*permitted)
  end

  def callback_params
    params.require(:provider)

    permitted = [
      :provider,
      :code,
      :scope,
      :state,
      :token,
      :client_id
    ]

    # Because omniauth's setup doesn't pass through headers, auth will have to
    # pass along our client ID in params.
    params[:client_id] = client.id if client

    params.permit(*permitted)
  end
end
