class V1::ScheduleController < V1::BaseController
  cache_actions :index

  def index
    events_reply = edb.events(filter_params, raise_on_error: true)
    series_reply = edb.series(filter_params, raise_on_error: true)
    events = events_reply[:json][:data].as_json.each {|obj| obj['type'] ||= 'Event'}
    series = series_reply[:json][:data].as_json.each {|obj| obj['type'] ||= 'Series'}

    # Events have `starts_at`, Series have `scheduled_at`.
    results =
      (events + series) \
      .select {|obj| obj['starts_at'] || obj['scheduled_at']} \
      .sort_by {|obj| obj['starts_at'] || obj['scheduled_at']} \
      .drop(filter_params.fetch(:offset, 0)) \
      .take(filter_params.fetch(:limit, 50))

    render json: {status: 200, data: results}
  end

  private

  def filter_params
    return @filter_params if @filter_params
    fparams = params.except(:action, :controller)

    [:limit, :offset].each do |param|
      next unless fparams[param]
      fparams[param] = fparams[param].to_i
      if fparams[param].to_s != params[param].to_s
        raise ActionController::BadRequest.new("invalid #{param}: #{params[param].inspect}")
      end
    end

    @filter_params = fparams.permit!
  end
end
