class V1::SeriesController < V1::BaseController
  api_path '/series',
    description: 'List series',
    method: :get,
    params: {
      ids: { in: :query },
      user_id: { in: :query }
    },
    responses: {
      200 => { schema: [:Series] }
    }

  def index
    render edb.series(params)
  end

  api_path '/series/{id}',
    description: 'Get series',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Series }
    }

  def show
    render edb.series(params)
  end

  api_path '/series/{id}',
    description: 'Update series',
    method: :patch,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Series }
    }

  def update
    render edb.update_series(params)
  end

  api_path '/series',
    description: 'Create series',
    method: :post,
    params: {},
    responses: {
      200 => { schema: :Series }
    }

  def create
    render edb.create_series(params)
  end

  api_path '/series/{id}',
    description: 'Destroy series',
    method: :delete,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Series }
    }

  def destroy
    render edb.delete_series(params)
  end
end
