class V1::TeamInvitationsController < V1::BaseController
  cache_flush_actions :create, :accept, :destroy

  api_path '/team_invitations',
    description: 'Create a team invitation',
    method: :post,
    params: {
      team_id: { in: :query, required: true }
    },
    responses: {
      200 => { schema: :TeamInvitation }
    }

  def create
    render edb.create_team_invitation(params)
  end

  api_path '/team_invitations/{token}/accept',
    description: 'Accept a team invitation',
    method: :patch,
    requires_user: true,
    params: {
      token: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Team }
    }

  def accept
    render edb.accept_team_invitation(params)
  end

  api_path '/team_invitations/{id}',
    description: 'Delete a team invitation',
    method: :delete,
    requires_user: true,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Team }
    }

  def destroy
    render edb.delete_team_invitation(params)
  end
end
