class V1::TeamMembersController < V1::BaseController
  cache_flush_actions :destroy

  api_path '/teams/{team_id}/members',
    description: "Get a team's members.",
    method: :get,
    params: {
      team_id: { in: :path, required: true },
      role: { in: :path, required: false }
    },
    responses: {
      200 => { schema: [:TeamMember] }
    }

  def index
    render edb.get_team_members(params)
  end

  api_path '/teams/{team_id}/members/{member_id}',
    description: "Get a specific team member.",
    method: :get,
    params: {
      team_id: { in: :path, required: true },
      member_id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :TeamMember }
    }

  def show
    render edb.get_team_member(params)
  end

  api_path '/teams/{team_id}/members',
    description: "Add a user to a team (admin-only).",
    method: :post,
    params: {
      team_id: { in: :path, required: true },
      user_id: { in: :body, required: true }
    },
    responses: {
      200 => { schema: :TeamMember }
    }

  def create
    render edb.create_team_member(params)
  end

  api_path '/teams/{team_id}/members/{member_id}',
    description: "Update a member's roles on a team.",
    method: :patch,
    params: {
      team_id: { in: :path, required: true },
      member_id: { in: :path, required: true },
      roles: { in: :body, required: true }
    },
    responses: {
      200 => { schema: [:TeamMember] }
    }

  def update
    render edb.update_team_member(params)
  end

  api_path '/teams/{team_id}/members/{member_id}',
    description: 'Remove the team member from the team.',
    method: :delete,
    params: {
      team_id: { in: :path, required: true },
      member_id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :TeamMember }
    }

  def destroy
    render edb.remove_team_member(params)
  end
end
