class V1::TeamUsersController < V1::BaseController
  cache_flush_actions :destroy

  api_path '/teams/{team_id}/users',
    description: "Get a team's users.",
    method: :get,
    params: {
      team_id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: [:User] }
    }

  def index
    render edb.get_team_users(params)
  end

  api_path '/teams/{team_id}/users',
    description: "Add a user to a team (admin-only).",
    method: :post,
    params: {
      team_id: { in: :path, required: true },
      user_id: { in: :body, required: true }
    },
    responses: {
      200 => { schema: :User }
    }

  def create
    render edb.create_team_user(params)
  end

  api_path '/teams/{team_id}/users/{user_id}',
    description: 'Remove the user from the team.',
    method: :delete,
    params: {
      team_id: { in: :path, required: true },
      user_id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Team }
    }

  def destroy
    render edb.remove_team_user(params)
  end
end
