class V1::TeamsController < V1::BaseController
  cache_actions :index, :show
  cache_flush_actions :create, :update

  api_path '/teams',
    description: 'List teams',
    method: :get,
    params: {
      ids: { in: :query }
    },
    responses: {
      200 => { schema: [:Team] }
    }

  def index
    render edb.teams(params)
  end

  api_path '/teams/{id}',
    description: 'Get team',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Team }
    }

  def show
    render edb.team(params)
  end

  def create
    render edb.create_team(params)
  end

  def update
    render edb.update_team(params)
  end
end
