class V1::TournamentEntriesController < V1::BaseController
  cache_actions :index
  cache_flush_actions :create, :update, :destroy

  api_path '/tournament_entries',
    description: 'List tournament entries`',
    tags: [:tournaments],
    method: :get,
    params: {
      tournament_id: { in: :query, required: false },
      ids: { in: :query, required: false }
    },
    responses: {
      200 => { schema: [:TournamentEntry] }
    }

  def index
    render edb.tournament_entries(params)
  end

  api_path '/tournaments_entries',
    description: 'Create a tournament entry',
    method: :post,
    requires_user: true,
    params: {
      team_id: { in: :query, required: true },
      tournament_id: { in: :query, required: true }
    },
    responses: {
      200 => { schema: :TournamentEntry }
    }

  def create
    render edb.create_tournament_entry(params)
  end

  api_path '/tournaments_entries/{id}',
    description: 'Update a tournament entry',
    method: :patch,
    requires_user: true,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :TournamentEntry }
    }

  def update
    render edb.update_tournament_entry(params)
  end

  api_path '/tournaments_entries/{id}',
    description: 'Delete a tournament entry',
    method: :delete,
    requires_user: true,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :TournamentEntry }
    }

  def destroy
    render edb.delete_tournament_entry(params)
  end
end
