class V1::TournamentsController < V1::BaseController
  cache_actions :index, :show
  cache_flush_actions :create, :update

  api_path '/tournaments',
    description: 'List tournaments',
    method: :get,
    params: {
      ids: { in: :query }
    },
    responses: {
      200 => { schema: [:Tournament] }
    }

  def index
    render edb.tournaments(params)
  end

  api_path '/tournaments/{id}',
    description: 'Get tournament',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Tournament }
    }

  def show
    render edb.tournament(params)
  end

  api_path '/tournaments',
    description: 'Create tournament',
    method: :post,
    params: {},
    responses: {
      200 => { schema: :Tournament }
    }

  def create
    render edb.create_tournament(params)
  end

  api_path '/tournaments/{id}',
    description: 'Update tournament',
    method: :patch,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: :Tournament }
    }

  def update
    render edb.update_tournament(params)
  end
end
