class V1::UsersController < V1::BaseController
  cache_actions :index, :show, expires_in: 1.hour
  cache_flush_actions :update, :verify_email

  api_path '/users',
    description: 'List users',
    method: :get,
    params: {},
    responses: {
      200 => { schema: [:User] }
    }

  def index
    render passport.users(params)
  end

  api_path '/users/{id}',
    description: 'Update user',
    method: :put,
    params: {
      id: { in: :path, required: true },
      email: { in: :query }
    },
    responses: {
      200 => { schema: [:User] }
    }

  def update
    # Update edb/Person first, UserPresenter will then grab the updated
    # Person object to merge into User.
    person = edb.update_person(params)
    params.each do |param, value|
      # Rewind any IO objects (e.g. user photos).
      value.rewind if value.respond_to?(:rewind)
    end
    user = passport.update_user(params)

    # If we have no user, but a Person ..
    if user.status != 200 && person.status == 200
      render json: V1::UserPresenter.new({ id: params[:id] },
                                         context: self) and return
    end

    render user
  end

  api_path '/users/{id}',
    description: 'Get user',
    method: :get,
    params: {
      id: { in: :path, required: true }
    },
    responses: {
      200 => { schema: [:User] }
    }

  def show
    user = passport.user(params)
    person = edb.person(params[:id])

    # If we have no user, but a Person ..
    if user.status != 200 && person.status == 200
      resp = {
        json: {
          status: 200,
          data: V1::UserPresenter.new({ id: params[:id] }, context: self).as_json
        }
      }
    else
      resp = user
    end

    render resp
  end

  def verify_email
    resp = passport.verify_email(params)

    # TODO refactor, see:
    # https://git-aws.internal.justin.tv/esports/tourney-edge/wiki
    if resp.status == 200
      body = JSON.parse(resp.body)
      if body.keys.include?('diff')
        edb_resp = edb.user_event({
          type: 'USER_CHANGE',
          data: body
        })
      end
    end

    render resp
  end
end
