class V1::BasePresenter
  def initialize(object, context: nil)
    @context = context
    @object = object
  end

  def object
    @object
  end

  def passport
    @context.passport
  end

  def edb
    @context.edb
  end

  def as_json(options={})
    object.as_json
  end

  # Moving away from embedding and merging all "join models" for cross-service
  # association, such as Person, into their root object instead.
  def merge!(object, key, &block)
    if object.is_a?(Array)
      return object.collect{|o| merge!(o, key, &block)}
    end

    if object.respond_to?(:has_key?) && object.has_key?(key)
      object.merge!(yield(object[key]))
    end

    object
  end

  # Recursively attempts to add [embed_key] where [key] is found
  # with the value yielded from a given block that is passed the value of [key]
  #
  # This is used to embed a user object where a user_id key is found, for
  # example.
  def embed(object, key, embed_key, &block)
    return object unless object.respond_to?(:keys)

    for _key in object.keys do
      if _key.match(key.is_a?(Regexp) ? key : /#{key.to_s}/)
        object[embed_key.to_s] = yield(object[_key])
      end

      if object[_key].is_a?(Hash)
        object[_key] = embed(object[_key], key, embed_key, &block)
      elsif object[_key].is_a?(Array)
        object[_key].each_with_index do |_object, i|
          object[_key][i] = embed(_object, key, embed_key, &block)
        end
      end
    end
    object
  end
end
