class V1::TeamPresenter < V1::BasePresenter
  def initialize(team, context: nil)
    super
    @team = team
  end

  def as_json(options = {})
    merge!(@team['users'], 'user_id') do |id|
      JSON.parse(passport.user({'id' => id}).body) if id.present?
    end
    @team
  end
end
